! Code Aspects, version 2.0.
! Michel Fioc, 2014-4-15. 

module mod_constants

! Constants used in the code.

  use mod_types, only : real_type
  implicit none

! $\pi$ and multiples:
  real(kind=real_type), parameter :: pi = 3.14159265358979, &
       two_pi = 2*pi, half_pi = pi/2

!++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
! To enforce or relax in simulations of catalogs the constraint on the 
! effective number of $K$-sources with a counterpart in $K'$ (used in 
! subroutine `simul_catalogs` of "mod_simul_catalogs.f90"):
    logical, parameter :: force_ctp_frac = .true.
! `.true.` if the number of $K$-sources associated to $K'$-ones is forced to 
! be equal to `n_u*input_f_u`, up to one unit;
! `.false.` if the probability that any $K$-source is associated is drawn with
! probability `input_f_u`, independently from the association status of other 
! $K$-sources.
! (Neglecting side effects in all cases.)

!######################################################################
! Parameters used in "mod_Aspects.f90".

! Ratio between the search radius for counterparts `R_ctp` and the maximal 
! value on $K$ and $K'$ of $\sqrt{a^2 + a'^2}$ ($a$ and $a'$ are the semi-major 
! axes of the positional uncertainty ellipses of $K$- and $K'$-sources):
  real(kind=real_type), parameter :: n_max_sigma = 5
! (Reasonable values should be in $[5, 10]$.)

!++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
! Ratio `R_ngb/R_ctp`, where `R_ngb` is the search radius for neighbors:
  real(kind=real_type), parameter :: R_ratio = 2
! (An `R_ngb` equal to a few times `R_ctp` seems reasonable.)

!++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
! Maximal number of neighbors (including the main source, so must be >= 1) 
! considered for one-to-one calculations:
  integer, parameter :: n_max_ngb = 8 

!++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
! For source $i$ and possible counterpart $j$, minimum ratio of
! $\xi_{i, j}/\xi_{i, 0}$:
  real(kind=real_type), parameter :: min_xi_ratio = 1.e-10
! (Should be <= 0 or << 1. If $\xi_{i, j}/\xi_{i, 0}$ < `min_xi_ratio`, 
! $\xi_{i, j}$ is set to 0 and $j$ is not considered as a possible counterpart
! of $i$.)

!++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
! Accuracy for the convergence of $f$ or $f'$:
  real(kind=real_type), parameter :: epsilon_f = 1.e-5 
! (An estimate $\hat f$ of $f$ is the limit of a sequence $f_{k+1} = g(f_k)$,
! where $g$ is some function. When $|f_{k+1}-f_k|$ < `epsilon_f`, the 
! iteration procedure stops and $\hat f$ is set to $f_{k+1}$.)

!++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
! Accuracy for the convergence of one-to-one probabilities:
  real(kind=real_type), parameter :: epsilon_oto_prob = 1.e-5 

!++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
! Parameter setting the accuracy of the one-to-one log-likelihood computed 
! with `compute_ln_oto_Lh`:
  real(kind=real_type), parameter :: epsilon_ln_oto_Lh = 1.e-3
! When `ln_oto_Lh` is computed by numerical integration of its derivative 
! `drv_ln_oto_Lh` (calculated from the o:o association probabilities) with 
! respect to `f`, an adaptative quadrature method is used: the grid of `f` 
! is recursively refined until the curvature of `drv_ln_oto_Lh` in any bin 
! $[f_l, f_u]$ becomes negligible (see the subroutine `refine_grid` in 
! "mod_Aspects.f90": the curvature is characterized by the difference between 
! `drv_ln_oto_Lh` at the midpoint of the bin and the average of 
! `drv_ln_oto_Lh` at the endpoints of the bin).
!
! The relative error of $`ln_oto_Lh`(f_u) - `ln_oto_Lh`(f_l)$ obtained by 
! integrating with the trapezoidal rule (i.e. with a linear interpolation 
! between the endpoints of a bin) would be at most of the order of 
! `epsilon_ln_oto_Lh`. 
! It is actually much better because the integration procedure used is based 
! on a cubic interpolation and thus takes into account the curvature.

!++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
! Shift of `oto_f` used to compute `std_dev_oto_f` from a finite 
! difference approximation to the second derivative at `oto_f` of 
! `ln_oto_Lh` with respect to `f`:
    real(kind=real_type), parameter :: d_f = 1.e-3

!++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
! Downward shift to the maximum possible value of `f_u` or `f_p`
! in calculations under the one-to-one assumption:
    real(kind=real_type), parameter :: f_max_shift = 1.e-3
! (Just for numerical reasons.)

  public

end module mod_constants
