! Code Aspects, version 2.0.
! Michel Fioc, 2014-4-15. 

module mod_heap_index
  
  use mod_types, only : real_type
  implicit none
  private
  public :: heap_index

contains
!======================================================================

  subroutine heap_index(a, idx)

! Given an array `a(1:n)`, return the array of integers `idx(1:n)`
! such that `a(idx(1:n))` is ordered by increasing values.
! Based on the "heapsort" algorithm.

    implicit none
    real(real_type), dimension(:), intent(in) :: a
    integer, dimension(:), intent(out) :: idx
!......................................................................
    integer :: n
    integer :: right, i
!______________________________________________________________________

    n = size(a)
    idx(1:n) = (/(i, i = 1, n)/)
    call heapify(a, idx, n)
    right = n
    do
       if (right <= 1) exit
       call swap(idx(right), idx(1))
       right = right - 1
       call sift_down(a, idx, 1, right)
    enddo

  end subroutine heap_index

!======================================================================

  subroutine swap(x, y)

    integer, intent(inout) :: x, y
!......................................................................
    integer :: tmp
!______________________________________________________________________

    tmp = y
    y = x
    x = tmp
    
  end subroutine swap

!======================================================================

  subroutine heapify(a, idx, n)

    implicit none
    integer, intent(in) :: n
    real(real_type), dimension(:), intent(in) :: a
    integer, dimension(:), intent(inout) :: idx
!......................................................................
    integer :: left
!______________________________________________________________________

    left = n/2
    do
       if (left < 1) exit
       call sift_down(a, idx, left, n)
       left = left - 1
    enddo

  end subroutine heapify

!======================================================================

  subroutine sift_down(a, idx, left, right)
    
    real(real_type), dimension(:), intent(in) :: a
    integer, dimension(:), intent(inout) :: idx
    integer, intent(in) :: left, right
!......................................................................
    integer :: root, left_child, right_child, tmp
!______________________________________________________________________

    root = left
    do
       left_child = 2*root
       if (left_child > right) exit
       tmp = root
       if (a(idx(tmp)) < a(idx(left_child))) tmp = left_child
       right_child = left_child + 1
       if (right_child <= right) then
          if (a(idx(tmp)) < a(idx(right_child))) tmp = right_child
       endif
       if (tmp /= root) then
          call swap(idx(root), idx(tmp))
          root = tmp
       else
          return
       endif

    enddo

  end subroutine sift_down

end module mod_heap_index
