! Code Aspects, version 2.0.
! Michel Fioc, 2014-4-15. 

module mod_types
  
  implicit none

! Kind used for all reals.
  integer, parameter :: real_type = selected_real_kind(P=15, R=307)

!######################################################################
! Structure containing the positions and positional uncertainties (all in radians).
  type coord_struct
     real(kind=real_type) :: alpha, & ! Right ascension.
          delta, & ! Declination.
          semi_axis_a, & ! 1-sigma positional uncertainty along the major axis,
!& independently from the position along the  minor axis.
          semi_axis_b, & ! 1-sigma positional uncertainty along the minor axis,
!& independently from the position along the  major axis.
          beta ! Angle, counted eastward, from the {direction of the North 
!& at the given position} to the major axis (in [0, `pi`[).)
  end type coord_struct

!######################################################################
! Structure containing data on neighbors and possible counterparts:
  type assoc_struct
!++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
! Quantities related to the counterparts associated with the *main* (central) 
! source; used in all computations. 
     integer :: n_ctp_main ! Cardinal number of possible counterparts.
     integer, dimension(:), pointer :: ctp_main => null() ! Indices of 
!& possible counterparts $M'_j$.
     real(kind=real_type), dimension(:), pointer :: xi_main => null() ! 
!& $\xi_{i, j}$, where $M_i$ is the main source.
     real(kind=real_type) :: sum_xi_main ! = $\sum_{j=1}^{n'} \xi_{i, j}$
!&      ($\xi_{i, 0}$ is excluded).
!++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
! Quantities related to the counterparts associated with *any* neighbor 
! of the main source (including the main source itself); 
! used only for one-to-one  calculations.
     integer :: n_ngb, & ! Cardinal number of neighbors.
          n_ctp_any ! Cardinal number of possible counterparts to any of the neighbors.
     integer, dimension(:), pointer :: ngb => null(), & ! Indices of neighbors.
          ctp_any => null() ! Indices of possible counterparts to any of the neighbors.
     integer, dimension(:), pointer :: corresp => null() ! Ordinal number, 
!& among the possible counterparts to any of the neighbors, corresponding to the ordinal
!& number of a possible counterpart to the main source: 
!&     `ctp_any(corresp(1:n_ctp_main))` = `ctp_main(1:n_ctp_main)`.
     real(kind=real_type), dimension(:,:), pointer :: xi_any => null() ! 
!& $\xi_{k, j}$, where $M_k$ is a neighbor of $M_i$.
  end type assoc_struct

!######################################################################
! Structure containing the probabilities of associations:
  type prob_struct
     integer :: n_ctp ! Cardinal number of possible real counterparts, so *excluding* 
!& counterpart `0` (= no counterpart).
     integer, dimension(:), pointer :: ctp => null() ! Indices of possible counterparts,
!& from 0 to `n_ctp`, so *including* counterpart `0`.
     real(kind=real_type), dimension(:), pointer :: prob => null() ! Corresponding 
!& probabilities of association (`prob(0)` is the probability that there is no counterpart).
  end type prob_struct

  private
  public :: real_type, coord_struct, assoc_struct, prob_struct

end module mod_types
