pro tellrem,infofile,telluricremovedspectra,silent=silent,nosave=nosave,noplot=noplot
;+
; NAME:
;	TELLREM
;
; PURPOSE:
;	This procedures creates telluric line removed spectra using the
;	information specified by the info file.
;
; CALLING SEQUENCE:
;	TELLREM,Infofile,Telluricremovedspectra
;
; INPUTS:
;	Infofile:  Absolute path to file containing the necessary
;		  information to run the procedures of the
;		  tellrem package. An example file called
;		  'info_for_tellrem' you can adjust for
;		  your needs is provided with the package. The
;		  format must be adhered to.
;	
; KEYWORD PARAMETERS:
;	NOSAVE:	Set this keyword if you do not want the results to be saved
;		to an IDL .sav file.
;	NOPLOT:	Set this keyword if you do not want plots of the results to
;		be created.
;
; OUTPUTS:
;	This procedure returns an array of structures 'Telluricremovedspectra'
;	containing the telluric line removed spectra and additional information
;	for each object. For each object the structure consists of the tags
;	'object' containing the object name in a string, 'obsdate' containing
;	the JD observation date as double scalar, 'obsaltitude' containing the
;	altitude angle the observation was taken at as double scalar, 'exptimeu'
;	containing the exposure time in the UVB arm as double scalar, 'exptimev'
;	containing the exposure time in the VIS arm as double scalar, 'exptimen'
;	containing the exposure time in the NIR arm as double scalar, 'wclu'
;	containing the wavelength array for the UVB data, 'clu' containing the
;	flux array of UVB, 'eclu' the error array of the UVB flux, 'wclv'
;	containing the wavelength array for the VIS data, 'clv' containing the
;	flux array of VIS, 'eclv' the error array of the VIS flux, 'wcln1'
;	containing the wavelength array for the NIR data in region 1, 'cln1'
;	containing the flux array of NIR in region 1, 'ecln1' the error array of
;	the NIR flux in region 1, 'wcln2' containing the wavelength array for the
;	NIR data in region 2, 'cln2' containing the flux array of NIR in region 2,
;	'ecln2' the error array of the NIR flux in region 2, 'wcln3' containing
;	the wavelength array for the NIR data in region 3, 'cln3' containing the
;	flux array of NIR in region 3, 'ecln3' the error array of the NIR flux in
;	region 3. The NIR arm spectrum is divided into 3 parts omitting the heavily
;	absorbed parts.
;
; EXAMPLE:
;	TELLREM,'/here/lies/info_for_tellrem',Telluricremovedspectra
;
; MODIFICATION HISTORY:
; 	Written by:	Natascha Rudolf, October 2013.
;-
; Copyright (C) 2013 Natascha Rudolf
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the "Software"), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
; The above copyright notice and this permission notice shall be included in all
; copies or substantial portions of the Software.
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
; SOFTWARE.
;-
; check the input parameters
if n_params() lt 2 then begin
    message,/info,'Syntax: TELLREM,Infofile,Telluricremovedspectra'
    retall
endif
; check keywords
if not keyword_set(nosave) then nosave=0
if not keyword_set(noplot) then noplot=0
if not keyword_set(silent) then silent=0

; get the info needed to run tellrem, i.e. create the common block TELLREM_INFO
loadtellreminfo,infofile

; get the objects to work on
objects=getobjects()

; determine parameters needed for the removal of telluric lines
tellremparams=tellremparameters(objects,nosave=nosave,noplot=noplot,silent=silent)

; do telluric line removal and build cleaned spectra
telluricremovedspectra=tellremspectra(tellremparams,nosave=nosave,silent=silent)
end