#!/bin/bash
##
## p3d_acquire_xtools.sh
##
## $Id: p3d_acquire_xtools.sh 79 2010-03-04 14:24:25Z christersandin $
##
## --
##
## p3d: a general data-reduction tool for fiber-fed IFSs
##
## Copyright 2009,2010 Astrophysikalisches Institut Potsdam (AIP)
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 3 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
## General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, see <http://www.gnu.org/licenses>.
##
## Additional permission under GNU GPL version 3 section 7
##
## If you modify this Program, or any covered work, by linking or
## combining it with IDL (or a modified version of that library),
## containing parts covered by the terms of the IDL license, the
## licensors of this Program grant you additional permission to convey
## the resulting work.
##
## --
##
## The purpose of this script is to download and install extra
## external IDL-routines which are required by p3d, but not
## distributed with p3d.
##
## NOTE! If you have already downloaded the required files to some
##       other location it is not necessary to use this routine.
##       In that case it is only necessary to setup the IDL startup
##       file (or the IDL preferences) to use the file at the
##       location you have.
##
## Requirements (that are all checked for in advance) are:
##  1) The tools wget and tar must exist in the path, and be
##     executable.
##  2) The environmental variable 'p3d_path' must be set prior to
##     calling this routine. It can be set in your system startup
##     script.
##  3) If the directory ${p3d_path}/contrib/astro-lib is a link nothing
##     is done. The script exits without doing anything.
##
##     Example of lines to add to the shell startup scripts:
##      .bashrc)  export p3d_path=/path/to/p3d/
##                export p3d_data_path=/path/to/my/data/
##                export PATH=$PATH:${p3d_path}/vm
##      .cshrc)   setenv p3d_path /path/to/p3d/
##                setenv p3d_data_path /path/to/my/data/
##                setenv PATH $PATH:${p3d_path}/vm
##
##  This script is designed to work with the following platforms:
##    MacOSX, Sun Solaris, and Linux.

screxe=${0##*/}

# Checking if the wget tool is available:
if [ ! -x `which wget` ];then
    echo "$screxe: Cannot find the tool wget."
    echo "$screxe: Cannot continue!"
    exit 1
fi

# Checking if the tar tool is available:
if [ ! -x `which tar` ];then
    echo "$screxe: Cannot find the tool tar."
    echo "$screxe: Cannot continue!"
    exit 1
fi

# Checking if $p3d_path is set:
if [ -z "$p3d_path" ]; then
    echo "$screxe: The environmental variable \$p3d_path"
    echo "$screxe:   has not been set. Cannot continue!"
    exit 1
fi

path=`pwd`
cd ${p3d_path}

if [ -L ${p3d_path}/contrib/astro-lib ]; then
    echo "$screxe: The directory ${p3d_path}/contrib/astro-lib \
is a symbolic link."
    echo "$screxe:   Will not continue!"
    cd $path
    exit 1
fi

# If the directories ${p3d_path]/contrib and
# ${p3d_path]/contrib/astro-lib exist they are deleted:
if [ -d ./contrib/astro-lib ]; then
  rm -rf ./contrib/astro-lib/*
fi
if [ -d ./contrib ]; then
  rm -rf ./contrib/*
fi
mkdir -p contrib/astro-lib

# Retrieving and extracting the astro-lib tar-file:
echo "$screxe: Downloading the latest version of the astro-lib package."
echo "$screxe: The downloaded file is deleted after its contents have been extracted."
if [ -f ./astron.tar.gz ]; then
  rm astron.tar.gz
fi
wget http://idlastro.gsfc.nasa.gov/ftp/astron.tar.gz
tar xfz astron.tar.gz -C contrib/astro-lib/ && rm astron.tar.gz

echo "$screxe: Downloading the required routines to use mpfit."
cd contrib
wget http://www.physics.wisc.edu/~craigm/idl/down/mpfit.pro
wget http://www.physics.wisc.edu/~craigm/idl/down/mpcurvefit.pro

cd $path

echo "$screxe: Done."
echo
echo "$screxe: Make sure your IDL startup file contains"
echo "$screxe: the appropriate lines. They could look like:"
echo "  !path='${p3d_path}/contrib/astro-lib/pro'+':'+!path"
echo "  !path='${p3d_path}/contrib'+':'+!path"
